// server.js
const express = require('express');
const cors = require('cors');
const mongoose = require('mongoose');
const dotenv = require('dotenv');
const authRoutes = require('./routes/auth'); // Import the auth routes
const dataRoutes = require('./routes/data');

dotenv.config();

const app = express();
const PORT = process.env.PORT || 5000;

app.use(cors({ origin: '*' })); // Adjust for production, e.g., { origin: 'http://your-frontend-domain.com' }
app.use(express.json());

// Connect to MongoDB
mongoose.connect(process.env.MONGO_URI, { useNewUrlParser: true, useUnifiedTopology: true })
  .then(() => console.log('MongoDB connected'))
  .catch(err => console.error('MongoDB connection error:', err));

// Routes
app.use('/api/auth', authRoutes.router); // Use authRoutes.router (correct property)
app.use('/api/data', dataRoutes);

// Start server
app.listen(PORT, () => console.log(`Server running on port ${PORT}`));